/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve summary reports.
	 * 
	 */
	public class LoadSummaryReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add summaryVO data to model
			model.reports.summaryReport.summaryVO = ReportFactory.buildSummaryVOFromXML(xml.averages.average);
			//add delay chart data to model..
			model.reports.summaryReport.delayLogs = ReportFactory.buildSummaryDelayChartFromXML(xml.delayChart.delay);
									
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_SUMMARY_REPORT;
		}
		
	}
}