/* LoadShiftReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve shift reports.
	 * 
	 */
	public class LoadShiftReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			model.reports.shiftReport.shiftCategories = ReportFactory.buildShiftReportCategoriesFromXML(xml.categories.category);
			model.reports.shiftReport.shiftReportColumns = ReportFactory.buildShiftReportColumnsFromXML(xml.columns.column);
									
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_SHIFT_REPORT;
		}
		
	}
}