/* LoadProviderReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve provider reports.
	 * 
	 */
	public class LoadProviderReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add providers to model
			model.reports.providerReport.providerList = ReportFactory.buildProviderListFromXML(xml.providers.md);

			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_PROVIDER_REPORT;
		}

	}
}