/* LoadPatientsRemovedInErrorReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;
	/** 
	 * This is the command used to request a LoadPatientsRemovedInError report.
	 */ 
	public class LoadPatientsRemovedInErrorReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add acuity stats to model
			model.reports.patientsRemovedInErrorReport.patientsRemovedInError = ReportFactory.buildPatientsRemovedInErrorFromXML(xml.removedInErrorEntries.log);
			
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_PATIENT_REMOVED_IN_ERROR_REPORT;
		}
		
	}
}