/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve patient cross-reference reports.
	 * 
	 */
	public class LoadPatientXRefReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add acuity stats to model
			model.reports.patientXRefReport.patientXRefList = ReportFactory.buildPatientXRefListFromXML(xml.patients.patient);
			
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_PATIENT_XREF_REPORT;
		}
		
	}
}