/* LoadMissedOpReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve missed opportunity reports.
	 * 
	 */
	public class LoadMissedOpReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add missedOp logs to model
			model.reports.missedOpReport.missedOpLogs = ReportFactory.buildReportLogEntriesFromXML(xml.logEntries.log);
			//Add disposition codes data..
			ReportFactory.buildMissedOpDispositionCodes(model.reports.missedOpReport, xml.totals);
											
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_MISSED_OP_REPORT;
		}
		
	}
}