/* LoadMissedOpReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to retrieve exposure reports.
	 * 
	 */
	public class LoadExposureReportCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
			
		/**
		 *   Constructor.
		 */
		public function LoadExposureReportCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate: ReportDelegate = new ReportDelegate(this);
			var reportEvent: ReportEvent = ReportEvent(event);
			delegate.loadReport(reportEvent);
			model.reports.exposureReport.id = reportEvent.reportParams.id;
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			
			//Point to the correct factory methods to process XML..
			model.reports.exposureReport.contagiousPtRoomList = ReportFactory.buildPatientExposureVOListFromXML(xml.patient.row);
			model.reports.exposureReport.ptsExposedinTreatmentRoomList = ReportFactory.buildPatientExposureVOListFromXML(xml.treatmentRoom.row);
			model.reports.exposureReport.allOtherPatientsList = ReportFactory.buildPatientExposureVOListFromXML(xml.otherPatients.row);
			
			model.reports.exposureReport.exposedMDsList = ReportFactory.buildEDStaffVOListFromXML(xml.onDutyStaff.doctors.md);
			model.reports.exposureReport.exposedNursesList = ReportFactory.buildEDStaffVOListFromXML(xml.onDutyStaff.nurses.rn);
			model.reports.exposureReport.exposedResidentsList = ReportFactory.buildEDStaffVOListFromXML(xml.onDutyStaff.residents.md);
											
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_EXPOSURE_REPORT;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error Loading Report: " + super.getFaultMessage(faultEvent);
		}		
	}
}