/* LoadPatientsRemovedInErrorReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;
	/** 
	 * This is the command used to request a custom report.
	 */ 
	public class LoadCustomReportCommand extends BaseReportCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add acuity stats to model
			model.reports.customReportRpt.CustomReport = ReportFactory.buildCustomReportXML(xml.customReportEntries.log);
			
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_CUSTOM_REPORT;
		}
		
	}
}