package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.CustomReportDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	
	/**
	 * Command to load ad hoc reports. 
	 *
	 */
	public class CustomReportConfigCommand extends AbstractResponderCommand implements ICommand, IResponder
	{		
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		protected var delegate:CustomReportDelegate;
		protected var loadEvent:ReportEvent;
		
		/**
		 * Constructor.  
		 */
		public function CustomReportConfigCommand()
		{			
		}
		
		public function execute(event:CairngormEvent):void
		{		
			delegate = new CustomReportDelegate(this);		
			loadEvent = ReportEvent(event);
			var role:String = loadEvent.role;
			delegate.customReport(model.logArea, role);
		}
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			var nodeList:XMLList = xml.worksheets.role;
			
		}
		
		
		/**
		 * Message that is returned when a fault occurs.
		 * @param faultEvent - The event associated with the fault.
		 * @return String - The message.
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Custom report config failed: " + super.getFaultMessage(faultEvent);
		}
		
		/**
		 * This method is called when a fault occurs.
		 * @param info The information regarding the fault.
		 * 
		 */
		override public function fault(info:Object):void
		{
			super.fault(info);
		}
		
	}
}
