package gov.va.med.edp.command.labs
{
	import gov.va.med.edp.command.LoadLabTrendCommand;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.reports.LabTrendVO;
	import gov.va.med.edp.control.LabTrendEvent;
	
	import mx.rpc.events.ResultEvent;
	/**
	 * Loads the microbiolgy portion of the labs.
	 */
	public class LoadMicrobiologyTrendCommand extends LoadLabTrendCommand
	{
		/**
		 * Constructor.
		 */
		public function LoadMicrobiologyTrendCommand()
		{
			super();
		}
		
		/**
		 * Process the results of the VistA RPC call
		 * @param The data object from the parent DataGrid
		 */
		override public function result(data:Object):void
		{
			var subscript:String;
			var labTrends:LabTrendVO;
			var element:XML = ResultEvent(data).result as XML;
			var labList:XMLList = element.results.item;
			for each (var lab:XML in labList) {
				
				subscript = lab.@subscript;
				
				if(subscript == LabTrendEvent.EVENT_LAB_MICROBIOLOGY_TREND) {
				
					labTrends = new LabTrendVO();
					//				labTrends.accession = lab.@testName;
					labTrends.collectedTS = Vista.FMtoDate(lab.@collectedTS).toLocaleString();
					labTrends.deviation = lab.@deviation;
					labTrends.high = lab.@high;
					//				labTrends.id = lab.@id;
					labTrends.low = lab.@low;
					//				labTrends.number = lab.@number;
					//				labTrends.order = lab.@order;
					//				labTrends.printName = lab.@printName;
					//				labTrends.printOrder = lab.@printOrder;
					labTrends.result = lab.@result;
					labTrends.resultedTS = Vista.FMtoDate(lab.@resultedTS).toLocaleString();
					//				labTrends.sample = lab.@sample;
					//				labTrends.specimen = lab.@sample;
					//				labTrends.stnName = lab.@stnName;
					//				labTrends.stnNum = lab.@stnNum;
					//				labTrends.subscript = lab.@subscript;
					//				labTrends.testID = lab.@testID;
					labTrends.testName = lab.@testName;
					labTrends.units = lab.@units;
					model.microbiologyVOList.addItem(labTrends);
				}
			}
		}	
	}
}