package gov.va.med.edp.command.labs
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import com.adobe.cairngorm.control.CairngormEventDispatcher;
	
	import gov.va.med.edp.business.LabTrendDelegate;
	import gov.va.med.edp.command.AbstractSequenceNotificationCommand;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.control.SwitchLogEntryEvent;
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.DateMath;
	import gov.va.med.edp.util.Vista;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	
	/**
	 * Loads the chem portion of the labs.
	 */
	public class LoadLabTestsCommand extends AbstractSequenceNotificationCommand
	{
		private var stopProcessingLabs: Boolean = false;
		private var loadEvent:LabTrendEvent;
		private var dfn:String;
		
		private var keys:Object = {};
		
		/**
		 * The EDIS model state.
		 */
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		/**
		 * Constructor for  LoadChemTrendCommand.
		 */
		public function LoadLabTestsCommand()
		{
			super();
			registerListeners();
			this.nextEvent = new LabTrendEvent(LabTrendEvent.EVENT_LAB_CHEM_TREND);
		}
		
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		override public function execute( event:CairngormEvent ) : void
		{
			
			super.execute(event);			
	
			loadEvent = LabTrendEvent( event );
			
			if (this.nextEvent != null) {
				if (this.nextEvent is LabTrendEvent) {
					// Forward the callback so we we notify of a 
					// successfull load after all labs are complete.
					(this.nextEvent as LabTrendEvent).callbacks = loadEvent.callbacks;
				}
			}
						
			var delegate:LabTrendDelegate = new LabTrendDelegate(this);

			var xml:XML;
			var totalLabsToRequest:int;
			var now:Date = new Date();
			var start:String;
			var stop:String;
			var duration:int;		
			
			totalLabsToRequest = model.totalLabsToRequest;
			xml = loadEvent.xml;		
			stop = Vista.DatetoFM(DateMath.addDays(now, 1));
						
			if (xml != null) {
				dfn = xml.@ptDfn;
				//duration = xml.@emins != null ? xml.@emins : 10;
				//start = Vista.DatetoFM(DateMath.subMinutes(now, duration));
				duration = model.priorLabsInterval;
				start = Vista.DatetoFM(DateMath.subWeeks(now, model.priorLabsInterval)); 
			}
			else {
				dfn = model.logEdit.entry.dfn;
				duration = model.priorLabsInterval;
				start = Vista.DatetoFM(DateMath.subWeeks(now, model.priorLabsInterval)); 
			}
					
			//Alert.show("LoadLabTestsCommand dfn = " + dfn + 
			//	" , stop = " + stop +
			//	" , stopD = " + Vista.FMtoDate(stop) +
			//	" , start = " + start +
			//	" , startD = " + Vista.FMtoDate(start) + 
			//	" , stopProcessingLabs = " + stopProcessingLabs);
			
			if(!stopProcessingLabs) {
				delegate.getLabTrendIds(dfn,start,stop);	
			}									
		}	
		
		/**
		 * Process the results of the VistA RPC call
		 * @param The data object from the parent DataGrid
		 */
		override public function result(data:Object):void
		{
			
			
			var element:XML = ResultEvent(data).result as XML;			
			//var testIDs:XMLList = element.results.item;
//			Alert.show("LabLabTestsCommand element = " + element);
			
			var testIDs:XMLList = element.item;
						
			var tIds:Array = new Array();
			
			var id:String;
			
			
			for each (var tId:XML in testIDs) {
				
				id = tId.@testID;
				
				if(id.length > 0)
				{
					if (!keys.hasOwnProperty(id)) {

						keys[id] = id;
						tIds.push(id);

					}
				}
				
			}
			
//			var filteredArr:Array = tIds.filter(removedDuplicates);
//			Alert.show(ObjectUtil.toString(tIds));
			model.testIds = new ArrayCollection(tIds);
					
			if (tIds.length > 0) {
				
				//Alert.show("LoadLabTestsCommand result nextEvent = " + this.nextEvent); 
				
				if(!stopProcessingLabs) {
				
					if(this.nextEvent != null) {
				
						(this.nextEvent as LabTrendEvent).testIds = model.getNextIds();
						(this.nextEvent as LabTrendEvent).logID = loadEvent.logID;
						
						this.executeNextCommand();
				
					}
				} 				
			} else {
				
				var noResultsEvent:WorkSheetWidgetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.NO_RESULTS,loadEvent.type);
				noResultsEvent.dispatch();
			}
		}
		
		private function removedDuplicates(item:Object, idx:uint, arr:Array):Boolean {
			if (keys.hasOwnProperty(item)) {
				/* If the keys Object already has this property,
				return false and discard this item. */
				return false;
			} else {
				/* Else the keys Object does *NOT* already have
				this key, so add this item to the new data
				provider. */
				keys[item] = item;
				return true;
			}
		}
		
		private function registerListeners():void
		{
			CairngormEventDispatcher.getInstance().addEventListener(SwitchLogEntryEvent.EVENT_SWITCH_LOG_ENTRY,handlePatientChange);
		}
		
		private function handlePatientChange(event:SwitchLogEntryEvent) :void
		{
			if (event.type == SwitchLogEntryEvent.EVENT_SWITCH_LOG_ENTRY) {

				if (loadEvent.logID != event.logID) 
				{
					stopProcessing();	
				}
				
				//Alert.show("LoadLabTestsCommand stopProcessingLabs " + stopProcessingLabs);
			} 						
		}
		
		private function stopProcessing():void
		{
			
			stopProcessingLabs = true;
			
			if(loadEvent != null)
			{
				loadEvent.stopImmediatePropagation();	
			}			
			
			if(nextEvent != null)
			{
				nextEvent.stopImmediatePropagation();
				nextEvent = null;
			}
			
			model.resetLabData();
					
		}
	}
}