package gov.va.med.edp.command.labs
{
	import gov.va.med.edp.command.LoadLabTrendCommand;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.reports.LabTrendVO;
	import mx.controls.Alert;
	import mx.rpc.events.ResultEvent;
	/**
	 * Loads the chem portion of the labs.
	 */
	public class LoadChemTrendCommand extends LoadLabTrendCommand
	{
		
		/**
		 * Constructor for  LoadChemTrendCommand.
		 */
		public function LoadChemTrendCommand()
		{
			super();			
			this.nextEvent = new LabTrendEvent(LabTrendEvent.EVENT_LAB_CHEM_TREND);			
		}
		
		/**
		 * Process the results of the VistA RPC call
		 * @param The data object from the parent DataGrid
		 */
		override public function result(data:Object):void
		{
			var collectedTS:String;
			var resultedTS:String;
			
			var subscript:String;
			var labTrends:LabTrendVO;
			var element:XML = ResultEvent(data).result as XML;
			//var labList:XMLList = element.results.item;
			var labList:XMLList = element.item;
						
			for each (var lab:XML in labList) {
				subscript = lab.@subscript;
				
				if(subscript != LabTrendEvent.EVENT_LAB_MICROBIOLOGY_TREND) {
										
					labTrends = new LabTrendVO();
					//				labTrends.accession = lab.@testName;
					collectedTS = lab.@collectedTS;
					if ((collectedTS != null) && (collectedTS.length > 0))
					{
						labTrends.collectedTS = Vista.FMtoDate(collectedTS).toLocaleString();	
					}
					//labTrends.collectedTS = Vista.FMtoDate(lab.@collectedTS).toLocaleString();
					labTrends.deviation = lab.@deviation;
					labTrends.high = lab.@high;
					//				labTrends.id = lab.@id;
					labTrends.low = lab.@low;
					//				labTrends.number = lab.@number;
					//				labTrends.order = lab.@order;
					//				labTrends.printName = lab.@printName;
					//				labTrends.printOrder = lab.@printOrder;
					labTrends.result = lab.@result;
					
					resultedTS = lab.@resultedTS;
					if ((resultedTS != null) && (resultedTS.length > 0))
					{
						labTrends.resultedTS = Vista.FMtoDate(resultedTS).toLocaleString();	
					}
					//labTrends.resultedTS = Vista.FMtoDate(lab.@resultedTS).toLocaleString();
					//				labTrends.sample = lab.@sample;
					//				labTrends.specimen = lab.@sample;
					//				labTrends.stnName = lab.@stnName;
					//				labTrends.stnNum = lab.@stnNum;
					//				labTrends.subscript = lab.@subscript;
					//				labTrends.testID = lab.@testID;
					labTrends.testName = lab.@testName;
					labTrends.units = lab.@units;
					model.labVOList.addItem(labTrends);
				}
			}
						
			if(!stopProcessingLabs) {
			
				if(this.nextEvent != null) {
			
					var currentIds:String = model.getNextIds();

					if(!model.labsComplete)
					{
			 	 	 (this.nextEvent as LabTrendEvent).testIds = currentIds;
					 (this.nextEvent as LabTrendEvent).logID = loadEvent.logID;
			 	 	 this.executeNextCommand();
					} else {
						this.nextEvent = null;
					}
			
				} else {
					model.resetLabData();
				}
			} else {
				model.resetLabData();			    		
			}
			
			// It is complete, load success	
			notifyCaller(data);	
		}
	}
}