package gov.va.med.edp.command.details
{
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.command.GetDetailsCommand;
	import gov.va.med.edp.vo.VitalsVO;
	import gov.va.med.edp.util.Vista;
	
	/**
	 * This command class communicates with the VistA RPC to retrieve vitals data for a patient.
	 * 
	 */
	public class GetVitalsDetailsCommand extends GetDetailsCommand
	{				
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */		
		public override function result(data:Object): void
		{
			var vital:VitalsVO;		
			var item:XML = ResultEvent(data).result as XML;			
			var vitalsList: XMLList = item.details.vital;
							
			for each (var v: XML in vitalsList) {
				vital = new VitalsVO();
				vital.bp = v.@BP;
				vital.ht = v.@HT;
				vital.p = v.@P;
				vital.pn = v.@PN;
				vital.r = v.@R;
				vital.t = v.@T;
				vital.wt = v.@WT;
				vital.error = (v.@error == "true") ? true : false;								
				//vital.time = Vista.FMtoDate(v.@time);
				vital.time = v.@time;
				model.vitalsModel.vitals.addItem(vital);
			}
			
			model.vitalsSaved = false;			
			
		}	
	} // class
} // package