package gov.va.med.edp.command.details
{
	import gov.va.med.edp.vo.RadiologyOrderVO;	
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.command.GetDetailsCommand;
	
	/**
	 * Command to retrieve the radiology order details.
	 * @author useruseruser12
	 */
	public class GetRadiologyCommand extends GetDetailsCommand
	{						
		/**
		 * Results of the radiology order details command.
		 * @param data The object in xml format.
		 */
		public override function result(data:Object): void
		{
			var radiologyOrder:RadiologyOrderVO;			
			var item:XML = ResultEvent(data).result as XML;
			var radList: XMLList = item.details.rad;
			
			for each (var ro: XML in radList) {
				radiologyOrder = new RadiologyOrderVO();
				radiologyOrder.report = ro.@report;
				model.radiologyVOList.addItem(radiologyOrder);
			}	
		}		
	} // class
} // package