package gov.va.med.edp.command.details
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.GetDetailsDelegate;
	import gov.va.med.edp.control.DetailsEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.reports.PtDemographicsVO;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.command.GetDetailsCommand;
	
	/**
	 * This command class communicates with the VistA RPC to retrieve demography data for a patient.
	 * 
	 */
	public class GetDemographyCommand extends GetDetailsCommand
	{
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */		
		public override function result(data:Object): void
		{
			var demog:PtDemographicsVO = new PtDemographicsVO();
			
			var item:XML = ResultEvent(data).result as XML;
			demog.address1 = item.details.address1;
			demog.age = item.details.age;
			demog.city = item.details.city;
			demog.dob = item.details.dob;
			demog.isVeteran = item.details.veteran;
			demog.maritalSts = item.details.maritalSts;
			demog.name = item.details.name;
			demog.sex = item.details.sex;
			demog.ssn = item.details.ssn;
			demog.state = item.details.state;
			demog.zip = item.details.zip;
			demog.phone = item.details.phone;
			demog.nok = item.details.nok;
			demog.nokPhone = item.details.nokPhone;
			demog.cell = item.details.cell;
			
			model.demog = demog;
			model.demogList.addItem(demog);
			
			model.demogReady = true;

		}
		
	} // class
} // package