package gov.va.med.edp.command.details
{
	import gov.va.med.edp.vo.ActiveProblemsVO;	
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.command.GetDetailsCommand;
	import mx.controls.Alert;
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	
	/**
	 * This command class communicates with the VistA RPC to retrieve active problems for a patient.
	 * 
	 */
	public class GetActiveProblemsCommand extends GetDetailsCommand
	{		
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */			
		public override function result(data:Object): void
		{
			var activeProblem:ActiveProblemsVO;			
			var item:XML = ResultEvent(data).result as XML;
			var probList: XMLList = item.details.problem;
			//Alert.show("GetActiveProblemsCommand item = " + item);
			for each (var problem: XML in probList) {
				activeProblem = new ActiveProblemsVO();
				activeProblem.name = problem.@name;
				activeProblem.icd = problem.@icd;	
				model.activeProblems.addItem(activeProblem);
			}
			
			notifyCaller(data);
			
			if (model.activeProblems.length == 0) {
				
				var noResultsEvent:WorkSheetWidgetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.NO_RESULTS,loadEvent.type);
				noResultsEvent.dispatch();
				
				//Alert.show("GetActiveProblemsCommand empty = " + loadEvent.type);
			}
			
			
		}	
	} // class
} // package