package gov.va.med.edp.command.details
{
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.command.GetDetailsCommand;
	import gov.va.med.edp.vo.ActiveMedVO;
	import mx.controls.Alert;
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	
	/**
	 * This command class communicates with the VistA RPC to retrieve active meds for a patient.
	 * 
	 */
	public class GetActiveMedsCommand extends GetDetailsCommand
	{		
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */			
		public override function result(data:Object): void
		{
			var activeMed:ActiveMedVO;		
			var item:XML = ResultEvent(data).result as XML;			
			var medList: XMLList = item.details.med;
			//Alert.show("GetActiveMedsCommand item = " + item);			
			for each (var med: XML in medList) {
				activeMed = new ActiveMedVO();
				activeMed.name = med.@name;
				activeMed.sig = med.@sig;
				activeMed.status = med.@status;		
				model.activeMeds.addItem(activeMed);
			}
		
			notifyCaller(data);
			
			if (model.activeMeds.length == 0) {
				
				var noResultsEvent:WorkSheetWidgetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.NO_RESULTS,loadEvent.type);
				noResultsEvent.dispatch();
				//Alert.show("GetActiveMedsCommand empty = " + loadEvent.type);
			}
		}	
	} // class
} // package