package gov.va.med.edp.command.debug
{
	import gov.va.med.edp.business.CSPService;
	import gov.va.med.edp.factory.DebugFactory;
	
	import mx.rpc.IResponder;

	/**
	 * This command class communicates with the VistA RPC to set up debug channel.
	 * 
	 */
	public class DebugHTTPServiceResponder implements IResponder
	{
		private var resultStr:String="";
		private var faultStr:String="";
		private var parameters:Object;
		private var cspService:CSPService=null;
		
		public function DebugHTTPServiceResponder(cspService:CSPService, parameters:Object){
			this.cspService = cspService;
			this.parameters = parameters;
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public function result(data:Object):void
		{
			resultStr = String(data.result);
			DebugFactory.updateDebugModel(cspService, resultStr, faultStr, parameters);	
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public function fault(data:Object):void
		{
			faultStr = data.toString();
			DebugFactory.updateDebugModel(cspService, resultStr, faultStr, parameters);
		}		
		
	}
}