/* UpdateStaffCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.UpdateStaffEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.AccessibilityTools;
	import gov.va.med.edp.vo.StaffMemberVO;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.utils.ObjectUtil;

	/**
	 * This command class communicates with the VistA RPC to add update staff in board configuration.
	 * 
	 */
    public class UpdateStaffCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function UpdateStaffCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var update: UpdateStaffEvent = UpdateStaffEvent(event);
			
//			Alert.show("update staff params =\n"+update.type+"\n"+ObjectUtil.toString(update.staff));

			if (update.type == UpdateStaffEvent.EVENT_ADD_STAFF) {
				switch (update.staff.role) {
					case "P":
                        addStaff(model.config.providers, update.staff);
                        break;
					case "R":
                        addStaff(model.config.residents, update.staff);
                        break;
					case "N":
                        addStaff(model.config.nurses, update.staff);
                        break;
					case "C":
						addStaff(model.config.clerks, update.staff);
						break;
				}
			} else if (update.type == UpdateStaffEvent.EVENT_REMOVE_STAFF) {
				removeStaff(update.staff);
			}
		}
		/** 
		 * Function add staff. 
		 * @param list to add to.
		 * @param staff of type StaffMemberVO. 
		 * 
		 */
        private function addStaff(list : ArrayCollection, staff : StaffMemberVO) : void {
            if (contains(list, staff)) {
                InfoDialog.show("Staff member " + staff.name + " has already been added and cannot be added again.");
                return;
            }
            staff.changed = true;
            list.addItem(staff);
            model.config.staffMods = true;
            
			if (AccessibilityTools.isAccessibilityActive())InfoDialog.show("added successfully", "Message", true);            

        }
		/** 
		 * Function remove staff. 
		 * 
		 * @param staff of type StaffMemberVO. 
		 * 
		 */
        private function removeStaff(staff : StaffMemberVO) : void {
            staff.inactive = true;
		    staff.changed = true;
            model.config.staffMods = true;
        }
		/** 
		 * Function verify staff in a list. 
		 * @param list to add to.
		 * @param staff of type StaffMemberVO. 
		 * 
		 */
        private function contains(list : ArrayCollection, staff : StaffMemberVO) : Boolean {
           for (var i:int = 0; i < list.length; i++) {
               var s : StaffMemberVO = list.getItemAt(i) as StaffMemberVO;
               if (s.duz == staff.duz) return true;
           }
           return false;
        }
    }
}
