/* SetModifiedCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.ConfigurationEvent;
	import gov.va.med.edp.model.TrackingModelLocator;

	/**
	 * This command class communicates with the VistA RPC to save modified fields to board configuration.
	 * 
	 */
	public class SetModifiedCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function SetModifiedCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var e: ConfigurationEvent = ConfigurationEvent(event);
			if (e.type == ConfigurationEvent.EVENT_BED_MODIFIED) {
				model.config.bedMods = true;
			}
			if (e.type == ConfigurationEvent.EVENT_BOARD_MODIFIED) {
				model.config.boardMods = true;
				trace("set modified");
			}
			if (e.type == ConfigurationEvent.EVENT_COLOR_MODIFIED) {
				model.config.colorMods = true;
			}
			if (e.type == ConfigurationEvent.EVENT_PARAM_MODIFIED) {
				model.config.paramMods = true;
			}
			if (e.type == ConfigurationEvent.EVENT_PARAM_MODIFIED_RESET) {
				model.config.paramMods = false;  // RESET (after creation complete)
			}
			if (e.type == ConfigurationEvent.EVENT_SELECTION_MODIFIED) {
				model.config.selectionMods = true;
			}
			if (e.type == ConfigurationEvent.EVENT_STAFF_MODIFIED) {
				model.config.staffMods = true;
			}
		}
	}
}
