/* SaveSelectionConfigCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.business.config.SaveSelectionConfigDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.command.AbstractSequenceCommand;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.control.config.ConfigurationEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to save selection data to board configuration.
	 * 
	 */
	public class SaveSelectionConfigCommand extends AbstractSequenceCommand implements IResponder
	{
		private namespace self;
		private var viewHandlers  : IResponder = null;
		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function SaveSelectionConfigCommand() 
		{
		}
		/**
		 *   event execution
		 */
		override public function execute(event:CairngormEvent): void
		{
			
			cacheCaller(event);

			var newStatuses: ArrayCollection;
			var newDispositions: ArrayCollection;
			var newDelays: ArrayCollection;
			var newArrivals: ArrayCollection;
						
			if (model.config.statusesChanged) {
				newStatuses = model.config.statuses;
			}
			if (model.config.dispositionsChanged) {
				newDispositions = model.config.dispositions;
			}
			if (model.config.delaysChanged) {
				newDelays = model.config.delays;
			}
			if (model.config.arrivalsChanged) {
				newArrivals = model.config.arrivals;
			}
			
			model.config.selectionConfigLoaded = false;
			var delegate: SaveSelectionConfigDelegate = new SaveSelectionConfigDelegate(this);
			delegate.saveSelectionConfig(model.logArea, model.config.selectionToken,
				newStatuses, newDispositions, newDelays, newArrivals);
			
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			if ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				BoardTools.applySelectionLists(model.config, xml);
				model.config.selectionConfigLoaded = true;
				
				this.nextEvent = new ConfigurationEvent(ConfigurationEvent.EVENT_LOAD_CONFIGURATION);
				this.executeNextCommand();
				notifyCaller(data);		
				
				if (xml.save.@status == "ok") {
					InfoDialog.show("New selection configuration saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for selections: " + super.getFaultMessage(faultEvent);
		}
		
		public override function fault(info:Object):void
		{
			notifyCaller(info);
			super.fault(info);
		}
		
		private function cacheCaller(event:Event):void {
			viewHandlers = getResponderFor(event);
		}
		
		private function getResponderFor(event:Event):IResponder {
			var results : IResponder = null;
			if (event != null) {
				if (event is TrackingEvent){
					results = (event as TrackingEvent).callbacks;
				}
			}
			return results;
		}
		
		self function result(info:Object):void {
			if (viewHandlers && (viewHandlers.result != null)) {
				viewHandlers.result(info);
			}
		}
		
		self function fault( info:Object ) : void {
			if (viewHandlers && (viewHandlers.fault != null)) {
				viewHandlers.fault(info);
			}
		}
		
		public function notifyCaller(results:* = null):void {
			if (results is FaultEvent) {
				self::fault(results);
			}
			else{
				self::result(results);
			}
		}
	}
}