/* SaveConfigParamsCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.SaveConfigParamsDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;

	/**
	 * This command class communicates with the VistA RPC to save config params to board configuration.
	 * 
	 */
	public class SaveConfigParamsCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function SaveConfigParamsCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate: SaveConfigParamsDelegate = new SaveConfigParamsDelegate(this);
			model.config.paramLoaded = false;
			delegate.saveConfigParams(model.logArea, model.config.params, model.config.paramToken);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			if ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				model.config.params = TrackingFactory.buildLogEditParamsFromXML(xml.params[0]);
				model.config.paramToken = xml.paramToken;
				model.config.paramMods = false;
				model.config.paramLoaded = true;

				if (xml.save.@status == "ok") {
					InfoDialog.show("New parameter configuration saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for parameters: " + super.getFaultMessage(faultEvent);
		}
	}
}