package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	
	import gov.va.med.edp.business.config.SaveConfigParamsDelegate;
	import gov.va.med.edp.business.worksheet.LoadWorkSheetListDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.command.AbstractSequenceCommand;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.control.config.ChangeFieldEvent;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.utils.ObjectUtil;
	
	/**
	 * The command to save config parameters.
	 */
	public class SaveConfigParamEnhancedCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		/*
		* The EDIS model state.
		*/
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 * Constructor.
		 */
		public function SaveConfigParamEnhancedCommand() 
		{	
		}
		
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute( event:CairngormEvent ) : void
		{
			model.unselectBoard = false;
			
			var e: ChangeFieldEvent = ChangeFieldEvent(event);
			model.config.paramMods = true;
			model.config.params.shiftStart = e.value;
//			Alert.show(ObjectUtil.toString(model.config.params.shiftStart));
			var delegate: SaveConfigParamsDelegate = new SaveConfigParamsDelegate(this);
			model.config.paramLoaded = false;
			delegate.saveConfigParams(model.logArea, model.config.params, model.config.paramToken);
		}
		
		/**
		 * Process the results of the VistA RPC call
		 * @param The data object from the parent 
		 */
		override public function result(data:Object):void
		{
			
			var xml:XML = ResultEvent(data).result as XML;	
			if ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				model.config.params = TrackingFactory.buildLogEditParamsFromXML(xml.params[0]);
				model.config.paramToken = xml.paramToken;
				model.config.paramMods = false;
				model.config.paramLoaded = true;
				
				if (xml.save.@status == "ok") {
					InfoDialog.show("New parameter configuration saved.");
					/* 
					 * This will deselect currently selected patient on the board.
					 */
					model.unselectBoard = true;
					
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for parameters: " + super.getFaultMessage(faultEvent);
		}
	}
}