/* SaveConfigColorsCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.SaveConfigColorsDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.ColorMatchVO;
	import gov.va.med.edp.widget.InfoDialog;
	import gov.va.med.edp.util.BoardTools;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to save config colors to board configuration.
	 * 
	 */
	public class SaveConfigColorsCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function SaveConfigColorsCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate: SaveConfigColorsDelegate = new SaveConfigColorsDelegate(this);

			var xml: XML = <colorSpec />;
			for each (var map: ColorMapVO in model.config.colorMaps) {
				var colors: XML = <colors />;
				colors.@id = map.id;
				colors.@type = map.type;
				for each (var match: ColorMatchVO in map.matches) {
					var node: XML = <map />;
					node.@att = match.attribute;
					node.@val = match.value;
					node.@clr = match.color.toString();
					colors.appendChild(node);
				}
				xml.appendChild(colors);
			}
			model.config.colorLoaded = false;
			delegate.saveConfigColors(model.logArea, xml, model.config.colorToken);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			if ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				BoardTools.applyColorSpec(xml.colorSpec.colors, model.config.colorMaps);
				model.config.colorToken = xml.colorToken;
				model.config.colorMods = false;
				model.config.colorLoaded = true;
				
				if (xml.save.@status == "ok") {
					InfoDialog.show("New board colors saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for colors: " + super.getFaultMessage(faultEvent);
		}
	}
}