/* MatchPersonCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.MatchPersonDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.config.MatchPersonEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to load staff matches to board configuration.
	 * 
	 */
	public class MatchPersonCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function MatchPersonCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var e: MatchPersonEvent = MatchPersonEvent(event);

			model.config.srcStaffReady = false;
			model.config.srcStaff = null;

			var delegate: MatchPersonDelegate = new MatchPersonDelegate(this);
			delegate.matchPersons(e.partial, e.personType);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			model.config.srcStaff = TrackingFactory.buildStaffListFromXML(xml.staff);
			model.config.srcStaffReady = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error matching persons: " + super.getFaultMessage(faultEvent);
		}
	}
}
