/* LoadConfigurationCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.LoadConfigurationDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.config.ConfigurationEvent;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.ColorMatchVO;
	import gov.va.med.edp.vo.DisplaySizeVO;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to initialize board configuration.
	 * 
	 */
	public class LoadConfigurationCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function LoadConfigurationCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			model.config.colorLoaded = false;
			model.config.bedLoaded = false;
			model.config.paramLoaded = false;
			var delegate: LoadConfigurationDelegate = new LoadConfigurationDelegate(this);
			var loadEvent: ConfigurationEvent = ConfigurationEvent(event);
			delegate.loadConfiguration(model.logArea);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	

			// load color info first so it can be referenced by columns
			// load color info - default maps
			model.config.colorMaps =
				TrackingFactory.buildColorMapListFromXML(xml.colorMaps.colors);

			// load color info - maps for current spec		
			BoardTools.applyColorSpec(xml.colorSpec.colors, model.config.colorMaps);
			model.config.colorToken = xml.colorToken;
			model.config.colorLoaded = true;
			
			// load available columns
			model.config.availableColumns = 
				TrackingFactory.buildColumnSpecListFromXML(xml.columnList.col, model.config.colorMaps);

			//load screen sizes
			model.config.displaySizes = TrackingFactory.buildScreenSizesFromXML(xml.screenSizes.size);
				
			// load room/bed info
			model.config.beds = 
				TrackingFactory.buildRoomBedListFromXML(xml.beds.bed);
			model.config.whenList = 
				SessionFactory.buildLookupListFromXML(xml.displayWhen.when);
			model.config.statusList = 
				SessionFactory.buildLookupListFromXML(xml.statusList.status);
			model.config.roomCategoryList =
				SessionFactory.buildLookupListFromXML(xml.roomCategories.item);
			model.config.bedToken = xml.bedToken;
			model.config.bedLoaded = true;
				
			// load parameter info
			model.config.params = TrackingFactory.buildLogEditParamsFromXML(xml.params[0]);
			model.config.defaultRoomList = SessionFactory.buildLookupListFromXML(xml.defaultRoomList.item);
			model.config.paramToken = xml.paramToken;
			model.config.paramLoaded = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error loading configuration for display board: " + super.getFaultMessage(faultEvent);
		}
	}
}