/* LoadConfigStaffCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.LoadConfigStaffDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to load staff to board configuration.
	 * 
	 */
	public class LoadConfigStaffCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
			
		/**
		 *   Constructor.
		 */
		public function LoadConfigStaffCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate: LoadConfigStaffDelegate = new LoadConfigStaffDelegate(this);
			model.config.staffConfigLoaded = false;
			delegate.loadConfigStaff(model.logArea);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			BoardTools.applyStaffLists(model.config, xml);
			model.config.staffConfigLoaded = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error loading configuration for staff: " + super.getFaultMessage(faultEvent);
		}		
	}
}