/* LoadBoardConfigCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.business.config.LoadBoardConfigDelegate;
	import gov.va.med.edp.control.config.BoardConfigEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.util.Vista;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to load board configuration.
	 * 
	 */
	public class LoadBoardConfigCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function LoadBoardConfigCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent): void
		{
			model.config.boardLoaded = false;
			var e: BoardConfigEvent = BoardConfigEvent(event);
			var delegate: LoadBoardConfigDelegate = new LoadBoardConfigDelegate(this);
						
			delegate.loadBoardConfig(model.logArea, e.boardID);
		}
		/**
		 *  This method is called by a service when the return value
		 *  has been received. 
		 *  While <code>data</code> is typed as Object, it is often
		 *  (but not always) an mx.rpc.events.ResultEvent.
		 */
		public override function result(data:Object): void
		{
			var xml:XML = ResultEvent(data).result as XML;	

			// load specific board spec
			BoardTools.applyBoardSpec(model.config, xml);
			model.config.boardLoaded = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error loading configuration for display board: " + super.getFaultMessage(faultEvent);
		}
	}
}