/* ConfigChangeColumnCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.ConfigChangeColumnEvent;
	import gov.va.med.edp.control.config.ConfigChangeDisplayBoardPropertiesEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.vo.ColumnSpecVO;

	/**
	 * This command class communicates with the VistA RPC to change a display properties in board configuration.
	 * 
	 */
	public class ConfigChangeDisplayBoardPropertiesCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
			
		/**
		 *   Constructor.
		 */
		public function ConfigChangeDisplayBoardPropertiesCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var changeEvent: ConfigChangeDisplayBoardPropertiesEvent = ConfigChangeDisplayBoardPropertiesEvent(event);
			if (changeEvent.type == ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_DISPLAY_WIDTH) {
				model.config.displayBoardProperties.displaySize = changeEvent.displaySize;
			}
			if (changeEvent.type == ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_FONT_SIZE) {
				model.config.displayBoardProperties.fontSize = changeEvent.fontSize;
			}
			if (changeEvent.type == ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_SCROLL_DELAY) {
				model.config.displayBoardProperties.scrollDelay = changeEvent.scrollDelay;
			}
			if (changeEvent.type == ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_SQUISH) {
				model.config.displayBoardProperties.squish = changeEvent.squish;
			}
			//Make sure this if block is the last in the code for the presence of a return statement
			// added ChangeFontSizeCommand -- do we still need this section?			
			if (changeEvent.type == ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_SQUISH_FONT_SIZE) {
				model.config.displayBoardProperties.squishFontSize = changeEvent.squishFontSize;
				return;
			}				
			model.config.boardMods = true;
			trace("change properties");
		}
	}
}