/* ConfigChangeColumnCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.ConfigChangeColumnEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.ColumnSpecVO;
	import gov.va.med.edp.util.BoardTools;

	/**
	 * This command class communicates with the VistA RPC to change a column in board configuration.
	 * 
	 */
	public class ConfigChangeColumnCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function ConfigChangeColumnCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var changeEvent: ConfigChangeColumnEvent = ConfigChangeColumnEvent(event);
			if (changeEvent.type == ConfigChangeColumnEvent.EVENT_CONFIG_CHANGE_COLUMN_SEQ) {
				var colSpec: Object = model.config.columns.removeItemAt(changeEvent.oldIndex);
				model.config.columns.addItemAt(colSpec, changeEvent.newIndex);
			}
			if (changeEvent.type == ConfigChangeColumnEvent.EVENT_CONFIG_CHANGE_COLUMN_WIDTH) {
				for (var i:int = 0; i < changeEvent.widths.length; i++) {
					ColumnSpecVO(model.config.columns[i]).width = changeEvent.widths[i];
				}
			}
			if (changeEvent.type == ConfigChangeColumnEvent.EVENT_CONFIG_CHANGE_ROW_COLOR) {
				model.config.rowColorMap = 
					BoardTools.locateColorMap(changeEvent.rowColor, model.config.colorMaps);
			}
			model.config.boardMods = true;
			trace("change column");
		}
	}
}