/* ChangeBedSequenceCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.ChangeBedSequenceEvent;
	import gov.va.med.edp.model.TrackingModelLocator;

	/**
	 * This command class communicates with the VistA RPC to change a bed in board configuration.
	 * 
	 */
	public class ChangeBedSequenceCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function ChangeBedSequenceCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var changeEvent: ChangeBedSequenceEvent = ChangeBedSequenceEvent(event);
			var bed: Object = model.config.beds.removeItemAt(changeEvent.oldIndex);
			model.config.beds.addItemAt(bed, changeEvent.newIndex);
			model.config.bedMods = true;
		}
	}
}