/* AddBoardCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.LookupVO;

	/**
	 * This command class communicates with the VistA RPC to add a board to board configuration.
	 * 
	 */
	public class AddBoardCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function AddBoardCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			// make sure we have a unique temporary name
			var boardName: String;
			for (var i: int = 1; i < 1000; i++) {
				boardName = "New-" + i;
				var dupFound: Boolean = false;
				for each (var board: LookupVO in model.config.boards) {
					if (board.label == boardName) {
						dupFound = true;
						break;
					}
				}
				if (!dupFound) break;
			}
			
			// add a new board entry (config will be based on last selected board)
			var newBoard: LookupVO = new LookupVO;
			newBoard.data = 0;
			newBoard.label = boardName;
			model.config.boards.addItem(newBoard);
			model.config.boardIndex = model.config.boards.getItemIndex(newBoard);
			model.config.boardMods = true;
		}
	}
}
