/* AddBedCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.AddBedEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.RoomBedVO;

	/**
	 * This command class communicates with the VistA RPC to add a bed to board configuration.
	 * 
	 */
	public class AddBedCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function AddBedCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var addEvent: AddBedEvent = AddBedEvent(event);
			var bed: RoomBedVO = new RoomBedVO();
			bed.area = model.logArea;
			bed.changed = true;
			bed.displayName = "new" + addEvent.newIndex;
			bed.displayWhen = 0;
			bed.id = 0;
			bed.name = bed.displayName;
			bed.sequence = 9999;
			model.config.beds.addItem(bed);
			model.config.bedMods = true;
		}
	}
}
