package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.UpdateVitalsDelegate;
	import gov.va.med.edp.control.UpdateVitalsEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.pt.demog.model.PatientSelectVO;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.vo.VitalsVO;
	import gov.va.med.edp.cpe.view.vitals.VitalsXml;
	import mx.controls.Alert;
	import mx.collections.ArrayCollection;
	
	
	/**
	 * The command to perform the vitals update
	 */
	public class UpdateVitalsCommand extends AbstractNotificationCommand
	{
		/**
		 * The EDIS model state.
		 */
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		public function UpdateVitalsCommand() {
		
			super();
		}
		
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public override function execute( event:CairngormEvent ) : void
		{
			
			super.execute(event);
			
			var updateEvent : UpdateVitalsEvent =
				UpdateVitalsEvent( event );
			
			var delegate:UpdateVitalsDelegate = new UpdateVitalsDelegate(this);
			
			var dfn:String = model.logEdit.entry.dfn;
			
			//Alert.show("UpdateVitalsCommand dfn = " + dfn + " , vital = " + model.vitalsVO.toString());
			
			delegate.updateVitals(dfn, model.vitalsVO.toString());						
			
		}
		
		/**
		 * Methods to parse result.
		 */
		public override function result(data:Object): void
		{
			var xml:XML = ResultEvent(data).result as XML;
			//Alert.show("UpdateVitalsCommand item = " + xml);
			var vitalNode:XML = xml.Vitals[0];
			model.vitalsModel.patientDfn = vitalNode.@dfn;
			
			var vitals: ArrayCollection = new ArrayCollection();
			
			vitals = VitalsXml.buildVitals(xml.Vitals);
			
			for each (var item:VitalsVO in vitals) {
				model.vitalsModel.vitals.addItem(item);	
			}
			
			model.vitalsSaved = false;
			notifyCaller(data);
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Saving vitals failed: " + super.getFaultMessage(faultEvent);
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public override function fault(info:Object): void
		{
			model.synchToLastEntry();
			super.fault(info);
		}
		
	}
	
}