package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.UpdateDemogDelegate;
	import gov.va.med.edp.control.UpdateDemogEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.pt.demog.model.PatientSelectVO;
	
	import mx.rpc.IResponder;

	
	/**
	 * The command to perform the demography update
	 */
	public class UpdateDemographyCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		/**
		 * The EDIS model state.
		 */
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		public function UpdateDemographyCommand() {}
		
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute( event:CairngormEvent ) : void
		{
			var updateEvent : UpdateDemogEvent =
				UpdateDemogEvent( event );
			
			var delegate:UpdateDemogDelegate = new UpdateDemogDelegate(this);
			
			/*  JNLTBD 
				Not sure which way to get the patient's ID
			*/
//			var dfn:String = (updateEvent.value as PatientSelectVO).dfn;
			var dfn:String = model.logEdit.entry.dfn;

			delegate.updateDemog(dfn, updateEvent.demog);

		}
		
	}
	
}