/* UndoLogEntryCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.model.TrackingModelLocator;

	/**
	 * This command class communicates with the VistA RPC to undo a save to a log entry.
	 * 
	 */
	public class UndoLogEntryCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function UndoLogEntryCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			if (!model.logEdit.dirty) return;
			
			model.logEdit.undo.copyTo(model.logEdit.entry);
			model.logEdit.message = "";
			model.logEdit.dirty = false;
			model.entryRemoveReady();
			//from AutoSave: model.editorViewState = TrackingModelLocator.VIEW_EDIT_FORM;
		}
	}
}