/* SwitchLogEntryCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.business.ServiceLocator;
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.Services;
	import gov.va.med.edp.business.SwitchLogEntryDelegate;
	import gov.va.med.edp.control.InitAppEvent;
	import gov.va.med.edp.control.SwitchLogEntryEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.LogEntryVO;
	
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to switch the patient log entry.
	 * 
	 */
	public class SwitchLogEntryCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function SwitchLogEntryCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent): void
		{
			var delegate:SwitchLogEntryDelegate = new SwitchLogEntryDelegate(this);
			var switchEvent:SwitchLogEntryEvent = SwitchLogEntryEvent(event);
			
			model.logEntryList.selectedIndex = switchEvent.selectedIndex;
			model.logEntryList.selectedID = switchEvent.logID;
			//trace("SwitchLogEntryCommand switchEvent.logID " +  switchEvent.logID + " model.logEdit.choiceTS " + model.logEdit.choiceTS);
			delegate.switchLogEntry(switchEvent.logID, null, model.logEdit.choiceTS);
			
			model.displayVisitSummary = false;
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object): void
		{
			var xml:XML = ResultEvent(data).result as XML;
//			Alert.show(xml.choices[0]);
			
			var index:int = 0;
			// make sure the choices are set up before setting the logEntry
			model.logEdit.setChoices(xml.choices[0]);
			
			if (Services(ServiceLocator.getInstance()).callMode == InitAppEvent.SERVICE_USE_MOCK) {
				//INA-Hack To Get Selected index for mocking // REMOVE
				index = model.logEntryList.selectedIndex;
			}
			
			// now that the choices are in place, we can set the log entry
			//model.logEdit.setEntry(TrackingFactory.buildLogEntryFromXML(xml.logEntry[0]));
			model.logEdit.setEntry(TrackingFactory.buildLogEntryFromXML(xml.logEntry[index]));
			model.logEdit.undo = new LogEntryVO;  // used for resetting status right now
			model.logEdit.entry.copyTo(model.logEdit.undo);
			model.logEdit.dirty = false;
			model.logEdit.patientSelected = false;
			model.entryRemoveReady();
			model.matchingDiagnoses = null;
			//model.setEditState();
//			Alert.show("switch log entry");
			model.displayVisitSummary = true;
			model.displayVisitWorksheet = true;
			
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Loading log entry failed: " + super.getFaultMessage(faultEvent);
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public override function fault(info:Object): void
		{
			model.synchToLastEntry();
			super.fault(info);
		}
		
	} // class
} // package