/* SwitchAppViewCommand.as */

package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.SwitchAppViewEvent;
	import gov.va.med.edp.control.TimerControlEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	/**
	 * This command class communicates with the VistA RPC to switch the app view.
	 * 
	 */
	public class SwitchAppViewCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function SwitchAppViewCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			
			
			
			var viewEvent: SwitchAppViewEvent = SwitchAppViewEvent(event);
			
			trace("SwitchAppViewCommand->" + viewEvent.view);
			
			if ((viewEvent.view == TrackingModelLocator.VIEW_APP_EDIT_CLOSED) &&
			    (model.appViewState != TrackingModelLocator.VIEW_APP_EDIT_CLOSED)) {
							
				model.logEdit.resetEntry();
				model.logEntryList.resetSelection();	
				
			}
			
			var e: TimerControlEvent;
			if (viewEvent.view == TrackingModelLocator.VIEW_APP_CPE ||
				viewEvent.view == TrackingModelLocator.VIEW_APP_DISPLAY_BOARD) {
				e = new TimerControlEvent(TimerControlEvent.START_TIMER);
				e.dispatch();
			}
			else {
				e = new TimerControlEvent(TimerControlEvent.STOP_TIMER);
				e.dispatch();
			}
			
			if (model.logEdit.entry == null) {
				model.logEdit.message = "No visit currently selected.";
			}
						
			model.appViewState = viewEvent.view;
				
			model.setEditState();
			
		}
	}
}