/* SortHeaderCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.control.SortHeaderEvent;

	/**
	 * This command class communicates with the VistA RPC to sort header columns in the display board.
	 * 
	 */
	public class SortHeaderCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function SortHeaderCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			var sortEvent: SortHeaderEvent = SortHeaderEvent(event);
			if (sortEvent.type == SortHeaderEvent.EVENT_SORT_LOG_SELECTOR) {
				model.logEntryList.sortField = sortEvent.sortField;
				model.logEntryList.sortDescending = sortEvent.sortDescending;				
			}
			if (sortEvent.type == SortHeaderEvent.EVENT_SORT_DISPLAY_BOARD) {
				model.boardSortField = sortEvent.sortField;
				model.boardSortDescending = sortEvent.sortDescending;
			}

		}
	}
}