package gov.va.med.edp.command
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.LabTrendDelegate;
	import gov.va.med.edp.business.SaveLogEntryDelegate;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.DateMath;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.control.DisplayBoardEvent;
	import mx.rpc.events.FaultEvent;
	import flash.events.Event;
	
	/**
	 * The command to perform the action of saving a log entry followed by a subsequent command.
	 */
	public class SaveSequenceCommand extends AbstractSequenceCommand implements IResponder
	{
		
		private namespace self;
		private var viewHandlers  : IResponder = null;

		
		/*
		 * The EDIS model state.
		 */
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		private var saveEvent : TrackingEvent;
		
		/**
		 * Constructor.
		 */
		public function SaveSequenceCommand() 
		{	
		}
			
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		override public function execute( event:CairngormEvent ) : void
		{

			cacheCaller(event);
			
			saveEvent = TrackingEvent( event );
			
			var delegate:SaveLogEntryDelegate = new SaveLogEntryDelegate(this);
			if (model.logEdit.dirty) {
				model.logEdit.dirty = false;
				delegate.saveLogEntry(model.logEdit.entry, model.logEdit.entry.id);
			}						
		}
		
		/**
		 * Process the results of the VistA RPC call
		 * @param The data object from the parent DataGrid
		 */
		override public function result(data:Object):void
		{
			
			var xml:XML = ResultEvent(data).result as XML;
			
//			Alert.show("SaveSequence result = \n"+xml.toXMLString());
			
			if (xml.upd.@status == "fail") {
				var msg: String = xml.upd.@msg;
				InfoDialog.show("Unable to save,  " + msg);
				model.logEdit.dirty = true;
				model.synchToLastEntry();
				if (msg.indexOf("Delay Reason") > -1) {
					model.logEdit.entry.requireDelay = true;
				}
			} else if (xml.upd.@status == "collision") {
				InfoDialog.show(xml.upd, "Updated Entry");
				model.logEdit.dirty = true;
				model.synchToLastEntry();
				model.logEdit.entry.loadTS = xml.upd.@loadTS;
			} else {

				model.logEdit.dirty = false;
				model.logEdit.message = "Entry saved.";
				model.logEditMessageFontSize = 10;
				model.logEdit.entry.loadTS = xml.logEntry.loadTS;

				//force the binding to fire...
				model.matchingClosedVisitsIndex = 0;
				model.matchingClosedVisitsIndex = -1;
				
				if(model.isNew) {
					model.isNew = false;	
				}
				
				
				if (saveEvent.type == TrackingEvent.EVENT_SAVE_AND_REFRESH_LOG_SELECTOR) {
					
					this.nextEvent = new TrackingEvent(TrackingEvent.EVENT_REFRESH_LOG_SELECTOR);				
					this.executeNextCommand();
					
				} else {
					
					this.nextEvent = new DisplayBoardEvent(DisplayBoardEvent.EVENT_REFRESH_DISPLAY_BOARD);				
					this.executeNextCommand();
					
				}
				
			}
						
			notifyCaller(data);							
		}
		
		/**
		 * Retrieve the failt message. 
		 * @param faultEvent
		 * @return 
		 * 
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Saving sequence failed: " + super.getFaultMessage(faultEvent);
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public override function fault(info:Object):void
		{
			model.logEdit.dirty = true;
			model.synchToLastEntry();
			notifyCaller(info);
			super.fault(info);
		}
		
		private function cacheCaller(event:Event):void {
			viewHandlers = getResponderFor(event);
		}
		
		private function getResponderFor(event:Event):IResponder {
			var results : IResponder = null;
			if (event != null) {
				if (event is TrackingEvent){
					results = (event as TrackingEvent).callbacks;
				}
			}
			return results;
		}
		
		self function result(info:Object):void {
			if (viewHandlers && (viewHandlers.result != null)) {
				viewHandlers.result(info);
			}
		}
		
		self function fault( info:Object ) : void {
			if (viewHandlers && (viewHandlers.fault != null)) {
				viewHandlers.fault(info);
			}
		}
		
		public function notifyCaller(results:* = null):void {
			if (results is FaultEvent) {
				self::fault(results);
			}
			else{
				self::result(results);
			}
		}
	}	
}