/* RestoreLogEntryCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.RestoreLogEntryDelegate;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/** 
	 * This is the command to send a request to restore a log entry. 
	 */ 
	public class RestoreLogEntryCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
			
		/**
		 *   Constructor.
		 */
		public function RestoreLogEntryCommand() 
		{
		}
		
		/** 
		 * This is the function to execute the event. 
		 * @param event Dispatched event. 
		 *
		 */
		public function execute(event:CairngormEvent):void
		{
						
			var delegate:RestoreLogEntryDelegate = new RestoreLogEntryDelegate(this);
			
			delegate.restoreLogEntry(model.logEdit.entry);

		}
		/** 
		 * This is the function that parses the result. 
		 * @param data The object to parse. 
		 *
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			if (xml.upd.@status == "fail") {
				var msg: String = xml.upd.@msg;
				InfoDialog.show("Unable to restore,  " + msg);
				model.logEdit.dirty = true;
				model.synchToLastEntry();
				if (msg.indexOf("Delay Reason") > -1) {
					model.logEdit.entry.requireDelay = true;
				}
			} else if (xml.upd.@status == "collision") {
				InfoDialog.show(xml.upd, "Updated Entry");
				model.logEdit.dirty = true;
				model.synchToLastEntry();
				model.logEdit.entry.loadTS = xml.upd.@loadTS;
			} else {

				model.logEdit.resetEntry();
				model.logEdit.message = "Entry restored.";
				model.logEditMessageFontSize = 10;
//				model.logEntryViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
				model.logEntryList.selectedIndex = -1;
				model.logEntryList.selectedID = 0;
				
				//force the binding to fire...
				model.matchingClosedVisitsIndex = 0;
				model.matchingClosedVisitsIndex = -1;
				
				new TrackingEvent(TrackingEvent.EVENT_REFRESH_LOG_SELECTOR).dispatch();
			}
		}
		/** 
		 * Displays the default error message. 
		 * @param faultEvent Fault event. 
		 *
		 */
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Restoring log entry failed: " + super.getFaultMessage(faultEvent);
		}
		/** 
		 * Occurs when there is a fault. 
		 * @param info Information regarding the fault. 
		 *
		 */
		public override function fault(info:Object):void
		{
			model.logEdit.dirty = true;
			model.synchToLastEntry();
			super.fault(info);
		}
	}
}