/* ResetDisplayBoardCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.ResetDisplayBoardDelegate;
	import gov.va.med.edp.control.DisplayBoardEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to reset the display board.
	 * 
	 */
	public class ResetDisplayBoardCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function ResetDisplayBoardCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate:ResetDisplayBoardDelegate = new ResetDisplayBoardDelegate(this);
			var resetEvent: DisplayBoardEvent = DisplayBoardEvent(event);
			delegate.resetDisplayBoard(model.session.area, resetEvent.name);
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
		}
		/**
		 *  This method is called by a service when an error has been received.
		 *  While <code>info</code> is typed as Object it is often
		 *  (but not always) an mx.rpc.events.FaultEvent.
		 */
		public override function fault(info:Object):void
		{
			InfoDialog.show("Unable to load display board spec.");
		}
	}
}