/* RefreshLogSelectorCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.RefreshLogSelectorDelegate;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.Vista;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to refresh the current patient log.
	 * 
	 */
	public class RefreshLogSelectorCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 *   Constructor.
		 */
		public function RefreshLogSelectorCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate:RefreshLogSelectorDelegate = new RefreshLogSelectorDelegate(this);
			delegate.refreshLogSelector(model.logArea, model.logEntryList.token);
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			//DONOT refresh if the Dirty flags is true. This is because the ChangeWatcher keeps different
			//components in sync but if the user is still editing and the referesh comes in the components get
			//out of sync..
			//ALSO only refresh the list if it has changed
			if (!model.logEdit.dirty && xml.logEntries.@status == "new"){
				model.logEntryList.entries =
					new ArrayCollection(TrackingFactory.buildLogSelectorListFromXML(xml.logEntries.log));
				model.logEntryList.token = xml.logEntries.@token;
				
				// sort based on previous settings
				if (model.logEntryList.sortField.length > 0) {
					var sort:Sort = new Sort();
					sort.fields = [new SortField(model.logEntryList.sortField, true, model.logEntryList.sortDescending)];
					model.logEntryList.entries.sort = sort;
					model.logEntryList.entries.refresh();
				}
				// now that it is sorted, reset the selected index (must set initial -1 to fire bindings)
				model.logEntryList.selectedIndex = -1;
				model.logEntryList.selectedIndex = 
					Vista.locateIndex(model.logEntryList.entries, model.logEntryList.selectedID, "id");
				// if the ID is no longer in the list, the entry must be closed
				if ((model.logEntryList.selectedIndex == -1) && (model.logEntryList.selectedID > 0)) {
					model.logEdit.resetEntry();
					model.logEdit.message = "Entry saved.";
//					model.logEntryViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
					//from AutoSave: model.editorViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
				}
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Refresh Log Selector failed: " + super.getFaultMessage(faultEvent);
		}
	}
}