/* RefreshDisplayBoardCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.RefreshDisplayBoardDelegate;
	import gov.va.med.edp.control.DisplayBoardEvent;
	import gov.va.med.edp.model.BigBoardDebugInfo;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.collections.XMLListCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.control.TrackingEvent;
	import mx.controls.Alert;

	/**
	 * This command class communicates with the VistA RPC to refresh the display board per time increment.
	 * 
	 */
	public class RefreshDisplayBoardCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		private var initDisplayBoardEvent: DisplayBoardEvent;
				
		/**
		 *   Constructor.
		 */
		public function RefreshDisplayBoardCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			
			//Alert.show("RefreshDisplayBoardCommand.execute");
			
			var delegate:RefreshDisplayBoardDelegate = new RefreshDisplayBoardDelegate(this);
			var refreshEvent: DisplayBoardEvent = DisplayBoardEvent(event);
		
			model.refreshReady = false;

			//save off the refreshEvent as an initDisplayBoardEvent in case we need to fire it if needed..
			initDisplayBoardEvent = new DisplayBoardEvent(DisplayBoardEvent.EVENT_INIT_DISPLAY_BOARD);
			initDisplayBoardEvent.name = refreshEvent.name;
			
			if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
				
				//.show("RefreshDisplayBoardCommand->APP_NAME_BIGBOARD configLastUpdated = " + model.boardSpec.configLastUpdated);
				delegate.refreshBigBoard(model.boardSpec.configLastUpdated);
				
			} else {
			
				//Alert.show("RefreshDisplayBoardCommand->APP_NAME_TRACKING configLastUpdated = " + model.boardSpec.configLastUpdated);
				delegate.refreshDisplayBoard(model.session.area, refreshEvent.name, model.boardSpec.configLastUpdated);
			
			}
			
			model.boardReady = false;
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

            // if the version on the server has changed we will need to load the new bigboard .swf automatically
            // (UI used by human will get updated during login process)
            //if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD && model.appClientVersion != xml.rows.@version) {
           //     model.logout();
            //    return;
           // }

            model.boardSpec.configLastUpdated = xml.rows.@configLastUpdated;
			model.boardSpec.reloadConfig = (xml.rows.@reloadConfig == "true");		
				
			//if reloadConfig is true, fire an InitDisplayBoard Event Instead..
			// this will cause the new Display Board Configuration and Data to be reloaded
			//instead of just reloading the data...
			if (model.boardSpec.reloadConfig == true){
				initDisplayBoardEvent.dispatch();
				return;			
			}
									
			model.boardData = null;
			model.boardData = new XMLListCollection(xml.rows.children() as XMLList);
			model.boardLastUpdated = new Date();

							
			// sort based on previous settings
			if (model.boardSortField.length > 0) {
				var sort: Sort = new Sort();
				//Do a numeric sort for any mins related columns
				if ((model.boardSortField.indexOf("min") != -1 )){
					sort.fields = [new SortField(model.boardSortField, true, model.boardSortDescending, true)];
				} else {
					sort.fields = [new SortField(model.boardSortField, true, model.boardSortDescending, false)];
				}
				model.boardData.sort = sort;
				model.boardData.refresh();
				
			}
			
			model.refreshReady = true;
			model.boardReady = true;
			
//			var e: TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_START_TIMER);
//			e.dispatch();
			
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Unable to refresh display board: " + super.getFaultMessage(faultEvent);
		}
	}
}