/*  MatchPatientsCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.MatchDiagnosesDelegate;
	import gov.va.med.edp.control.MatchItemsEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to match diagnoses for a given patient.
	 * 
	 */
	public class MatchDiagnosesCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function MatchDiagnosesCommand() 
		{
		}
		
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{

			var matchDiagnosesEvent:MatchItemsEvent = MatchItemsEvent(event);
 			if ((matchDiagnosesEvent.partial == null) || (matchDiagnosesEvent.partial.length == 0)) {
				model.matchingDiagnoses = null;
				return;
			}
			
			var delegate:MatchDiagnosesDelegate= new MatchDiagnosesDelegate(this);
			delegate.matchDiagnoses(matchDiagnosesEvent.partial);
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			model.matchingDiagnosesLoaded = false;
			var xml:XML = ResultEvent(data).result as XML;
			model.matchingDiagnoses = 
				TrackingFactory.buildLookupDiagnosesListFromXML(xml);
			model.matchingDiagnosesLoaded = true;
				
		}
	
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Retrieve matching diagnoses failed: " + super.getFaultMessage(faultEvent);
		}
	
	}
}