/*  MatchClosedVisitsCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.MatchClosedVisitsDelegate;
	import gov.va.med.edp.control.MatchItemsEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to match closed visit searches.
	 * 
	 */
	public class MatchClosedVisitsCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function MatchClosedVisitsCommand() 
		{
		}
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		public function execute(event:CairngormEvent):void
		{
			model.matchingClosedFinished = false;
			var matchEvent: MatchItemsEvent = MatchItemsEvent(event);
 			if ((matchEvent.partial == null) || (matchEvent.partial.length == 0)) {
				model.matchingClosedVisits = null;
				return;
			}
			
			var delegate:MatchClosedVisitsDelegate = new MatchClosedVisitsDelegate(this);
			delegate.matchClosedVisits(model.logArea, matchEvent.partial);
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			model.matchingClosedVisits = 
				TrackingFactory.buildVisitListFromXML(xml.visit);
			model.logEdit.resetEntry();
			//model.setEditState();
			model.matchingClosedVisitsIndex = -1;
			if(model.matchingClosedVisits.length > 1) 
			{
				model.matchingClosedFinished = true;	
			}
				
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Retrieve closed visits failed: " + super.getFaultMessage(faultEvent);
		}
	}
}