package gov.va.med.edp.command
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import com.adobe.cairngorm.control.CairngormEventDispatcher;
	import gov.va.med.edp.business.LabTrendDelegate;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.control.SwitchLogEntryEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.DateMath;
	import gov.va.med.edp.util.Vista;
	
	import mx.rpc.IResponder;
	import mx.controls.Alert;
	
	/**
	 * The command to perform the action of loading labs for a given patient
	 */
	//public class LoadLabTrendCommand extends AbstractSequenceCommand implements IResponder
	public class LoadLabTrendCommand extends AbstractSequenceNotificationCommand implements IResponder 
	{
		protected var stopProcessingLabs: Boolean = false;
		protected var loadEvent:LabTrendEvent;
		protected var dfn:String;
		/**
		 * The EDIS model state.
		 */
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 * Constructor.
		 */
		public function LoadLabTrendCommand() 
		{
			registerListeners();
		}
			
		/**
		 * The execute of the user selected event; calls the Update Delegate
		 * @param event The generic Cairngorm event
		 */
		override public function execute( event:CairngormEvent ) : void
		{
			
			super.execute(event);
			
			loadEvent =	LabTrendEvent( event );
			
			if (this.nextEvent != null) {
				if (this.nextEvent is LabTrendEvent) {
					// Forward the callback so we we notify of a 
					// successfull load after all labs are complete.
					(this.nextEvent as LabTrendEvent).callbacks = loadEvent.callbacks;
				}
			}
			
			var delegate:LabTrendDelegate = new LabTrendDelegate(this);
			
			var dfn:String;
			var xml:XML;
			var now:Date = new Date();
			var start:String;
			var stop:String;
			var duration:int;			
			var testIds:String;
			
			xml = loadEvent.xml;		
			stop = Vista.DatetoFM(DateMath.addDays(now, 1));
			
			testIds = loadEvent.testIds;

			if (xml != null) {
				dfn = xml.@ptDfn;
				duration = xml.@emins != null ? xml.@emins : 10;
				start = Vista.DatetoFM(DateMath.subMinutes(now, duration));
			}
			else {
				dfn = model.logEdit.entry.dfn;
				duration = model.priorLabsInterval;
				start = Vista.DatetoFM(DateMath.subWeeks(now, model.priorLabsInterval)); 
			}
			
			//Alert.show("LoadLabTrendCommand dfn = " + dfn + 
			//	" , stop = " + stop +
			//	" , stopD = " + Vista.FMtoDate(stop) +
			//	" , start = " + start +
			//	" , startD = " + Vista.FMtoDate(start) +
			//	" , testID = " + testIds);
			
			//delegate.getLabTrendTestIds(dfn,start,stop,testIds);
			
			if(!stopProcessingLabs) {
				delegate.getLabTrendTestIds(dfn,start,stop,testIds);	
			}
			
		}
		
		private function registerListeners():void
		{
			CairngormEventDispatcher.getInstance().addEventListener(SwitchLogEntryEvent.EVENT_SWITCH_LOG_ENTRY,handlePatientChange);
		}
		
		protected function handlePatientChange(event:SwitchLogEntryEvent) :void
		{
			if (event.type == SwitchLogEntryEvent.EVENT_SWITCH_LOG_ENTRY) {
				
				if (loadEvent.logID != event.logID) 
				{
					stopProcessing();	
				}
				
				//Alert.show("LoadLabTrendCommand stopProcessingLabs " + stopProcessingLabs);
			} 						
		}
		
		protected function stopProcessing():void
		{
			stopProcessingLabs = true;
			
			if(loadEvent != null)
			{
				loadEvent.stopImmediatePropagation();	
			}			
			
			if(nextEvent != null)
			{
				nextEvent.stopImmediatePropagation();
				nextEvent = null;
			}
			
			model.resetLabData();
		}
	}	
}