/* InitTrackingCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.InitTrackingDelegate;
	import gov.va.med.edp.control.SwitchAppViewEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.LookupVO;
	import gov.va.med.edp.control.InitLogAreaEvent;
	import gov.va.med.edp.widget.InfoDialog;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.controls.Alert;
	
	/**
	 * This command class communicates with the VistA RPC to initialize the data tracking environment.
	 * 
	 */
	public class InitTrackingCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		private static const NO_DEFAULT_ROOM_MESSAGE:String = "EDIS has determined that your system does not " +
			"have a default Room/Area setup.\n\n" +
			"Please have your Clinical Application Coordinator set this up accordingly.\n\n" +
			"In the meantime, new patients will be added to the EDIS_DEFAULT room.";
		
		private static const NO_DEFAULT_ROOM_TITLE:String = "WARNING - No Default Room/Area";

		/**
		 *   Constructor.
		 */
		public function InitTrackingCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate: InitTrackingDelegate = new InitTrackingDelegate(this);
			//Alert.show("InitTrackingCommand-> execute  areaName : " + model.session.areaName);
			delegate.initTracking(model.session.areaName);
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			//Alert.show("InitTrackingCommand-> result : " + xml);
			
            model.session.serverPackageVersion = xml.user[0].@version;
            if (model.session.area <= 0) {
	            model.session.area = xml.user[0].@area;
				model.session.areaName = xml.user[0].@areaNm;				
				//Alert.show("InitTrackingCommand-> again : " + model.session.toString());
            }

			model.session.defaultRoom = xml.user[0].@defaultRoom;
			
			displayWarningIfExists();
			
			var initEvent:InitLogAreaEvent =
				new InitLogAreaEvent(InitLogAreaEvent.EVENT_INIT_LOG_AREA);
			initEvent.area = model.session.area;  // get the default area
			initEvent.dispatch();
			
            model.logArea = model.session.area;  // set initial logArea value
			
			
			//Alert.show("InitTrackingCommand-> result model.appName : " +  model.appName);
			
			if (model.appName == TrackingModelLocator.APP_NAME_TRACKING) {
                var e:SwitchAppViewEvent = new SwitchAppViewEvent(SwitchAppViewEvent.EVENT_SWITCH_APP_VIEW);
				
//				if (isVersionIncompatibility()) {
//                    e.view = TrackingModelLocator.VIEW_APP_VERSION_INCOMPATIBILITY;
//                } else if (model.appViewList.length > 0) {
//					e.view = TrackingModelLocator.VIEW_APP_INTRO_CPE;
//				}
				
				e.view = TrackingModelLocator.VIEW_APP_INTRO_CPE;
				e.dispatch();
            } else if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
//                if (isVersionIncompatibility()) {
//                    model.appViewState = TrackingModelLocator.VIEW_APP_VERSION_INCOMPATIBILITY;
//                } else {
//                    model.appViewState = TrackingModelLocator.VIEW_APP_DISPLAY_BOARD;
//                }
				
				model.appViewState = TrackingModelLocator.VIEW_APP_DISPLAY_BOARD;
            }
		}

        private function isVersionIncompatibility():Boolean {
            return model.appClientVersion != model.session.serverPackageVersion;
        }

        protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Unable to initialize tracking views: " + super.getFaultMessage(faultEvent);
		}
		
		
		private function displayWarningIfExists():void {
			if (model.session.defaultRoom == "false") {
				InfoDialog.show(NO_DEFAULT_ROOM_MESSAGE,
					NO_DEFAULT_ROOM_TITLE,
					false,
					null,
					null,
					"Close",
					340,
					210,
					"infoDialogStyle",
					"infoDialogTitleStyle");
			}
		}
	}
}
