/* InitDisplayBoardCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.InitDisplayBoardDelegate;
	import gov.va.med.edp.control.DisplayBoardEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.BigBoardDebugInfo;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.DisplayBoardPropertiesVO;
	
	import mx.collections.ArrayCollection;
	import mx.collections.XMLListCollection;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	/**
	 * This command class communicates with the VistA RPC to initialize the display board environment.
	 * 
	 */
	public class InitDisplayBoardCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		/**
		 *   Constructor.
		 */
		public function InitDisplayBoardCommand() 
		{
		}
		/**
		 *   event execution
		 */
		public function execute(event:CairngormEvent):void
		{
			var delegate:InitDisplayBoardDelegate = new InitDisplayBoardDelegate(this);
			
			if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
				
				delegate.initBigBoard();
				
			} else {
				
				var initEvent:DisplayBoardEvent = DisplayBoardEvent(event);
				delegate.initDisplayBoard(model.session.area, initEvent.name);
				
			}
					
			model.boardSpec.specReady = false;
			model.boardReady = false;
		}
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
		public override function result(data:Object):void
		{
			var xml: XML = ResultEvent(data).result as XML;
			
			
			// Define variable to hold the Alert object. 
			/*var myAlert:Alert;
			
			myAlert = Alert.show("xml.rows.children() = " + xml.rows.children());
			
			//myAlert.height=1000;
			//myAlert.width=1000;
			
			myAlert = Alert.show("xml.spec.row.@color = " + xml.spec.row.@color);
			myAlert = Alert.show("xml.spec.displayProperties = " + xml.spec.displayProperties);
			myAlert = Alert.show("xml.spec.col = " + xml.spec.col);
			myAlert = Alert.show("xml.colorSpec.color = " + xml.colorSpec.colors);
			*/
			
			//myAlert = Alert.show("ALL = " + xml);
			
			//myAlert.height=1000;
			//myAlert.width=1000;
			
			//Alert.show("xml.colorSpec.color = " + xml.colorSpec.colors);
			//Alert.show("xml.spec.col = " + xml.spec.col);
			//Alert.show("xml.spec.displayProperties = " + xml.spec.displayProperties);
			//Alert.show("xml.spec.row.@color = " + xml.spec.row.@color);
			//Alert.show("xml.rows.children() = " + xml.rows.children());
						
			var colorMaps: ArrayCollection = TrackingFactory.buildColorMapListFromXML(xml.colorSpec.colors);
	
			// build the color maps first so they can be referenced by columns
			//model.boardSpec.colorMaps = TrackingFactory.buildColorMapListFromXML(xml.colorSpec.colors);
			
			var columns: ArrayCollection = TrackingFactory.buildColumnSpecListFromXML(xml.spec.col, colorMaps);
			
			// build the column specs
			//model.boardSpec.columns =
			//	TrackingFactory.buildColumnSpecListFromXML(xml.spec.col, model.boardSpec.colorMaps);
				
			var displayBoardProperties: DisplayBoardPropertiesVO = TrackingFactory.buildDisplayBoardPropertiesFromXML(xml.spec.displayProperties);
			
			//build display properties
			//model.boardSpec.displayBoardProperties =
    		//	TrackingFactory.buildDisplayBoardPropertiesFromXML(xml.spec.displayProperties);

			var rowColorMap: ColorMapVO = BoardTools.locateColorMap(xml.spec.row.@color, colorMaps);
			
			// build the row spec			
			//model.boardSpec.rowColorMap =
			//	BoardTools.locateColorMap(xml.spec.row.@color, model.boardSpec.colorMaps);
		
			var boardData: XMLListCollection = new XMLListCollection(xml.rows.children() as XMLList);
		
			
			// load the actual data for the board
			//model.boardData = new XMLListCollection(xml.rows.children() as XMLList);
			
			//model.bigboardInfo = new BigBoardDebugInfo();
			//model.bigboardInfo.bigBoardSiteCode = xml.vistalinkConnectionInfo.siteId;
			//model.bigboardInfo.bigBoardMachineName = xml.vistalinkConnectionInfo.machineName;	
			//model.bigboardInfo.vistaLinkIPAddress = xml.vistalinkConnectionInfo.vistalinkIPAddress;
			//model.bigboardInfo.vistaLinkPort = xml.vistalinkConnectionInfo.vistalinkPort;			
			
			//model.boardSpec.colorMaps = new ArrayCollection(colorMaps.source);
			//model.boardSpec.columns = new ArrayCollection(columns.source);
			model.boardSpec.colorMaps = colorMaps;
			model.boardSpec.columns = columns;
			model.boardSpec.displayBoardProperties = displayBoardProperties;
			model.boardSpec.rowColorMap = rowColorMap;
			model.boardData = boardData;
			
			model.bigboardInfo = new BigBoardDebugInfo();
			model.bigboardInfo.bigBoardSiteCode = xml.vistalinkConnectionInfo.siteId;
			model.bigboardInfo.bigBoardMachineName = xml.vistalinkConnectionInfo.machineName;	
			model.bigboardInfo.vistaLinkIPAddress = xml.vistalinkConnectionInfo.vistalinkIPAddress;
			model.bigboardInfo.vistaLinkPort = xml.vistalinkConnectionInfo.vistalinkPort;
			
			model.boardSpec.specReady = true;
			
			model.boardLastUpdated = new Date();
			model.boardReady = true;
			
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Initialize display board failed: " + super.getFaultMessage(faultEvent);
		}

	}
}