/* InitAppCommand.as */

package gov.va.med.edp.command
{
	import com.adobe.cairngorm.business.ServiceLocator;
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.display.DisplayObject;
	
	import gov.va.med.edp.business.InitUserDelegate;
	import gov.va.med.edp.business.Services;
	import gov.va.med.edp.command.AbstractSequenceNotificationCommand;
	import gov.va.med.edp.control.InitAppEvent;
	import gov.va.med.edp.control.InitLogAreaEvent;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.control.worksheet.LoadWorkSheetEvent;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.view.ErrorDialog;
	import gov.va.med.edp.vo.SessionVO;
	import gov.va.med.edp.widget.InfoDialog;
	import gov.va.med.edp.widget.OkCancelDialog;
	
	import mx.containers.Panel;
	
	import mx.controls.Label;
	import mx.core.Application;
	import mx.events.CloseEvent;
	import mx.managers.PopUpManager;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	/**
	 * This command class communicates with the VistA RPC to initialize the EDIS application environment.
	 * 
	 */
	public class InitAppCommand extends AbstractSequenceNotificationCommand
    {
        private var model:TrackingModelLocator = TrackingModelLocator.getInstance();

		/**
		 *   Constructor.
		 */
		public function InitAppCommand() 
		{
			super();
			this.nextEvent = new LoadWorkSheetEvent(LoadWorkSheetEvent.EVENT_LOAD_REQUIRED_WORKSHEETS);		
			
		}
		/**
		 *   event execution
		 */
		override public function execute(event:CairngormEvent):void
        {
			
			super.execute(event);
			
            // set up Services.mxml so it knows the runtime URL
            var e: InitAppEvent = InitAppEvent(event);
            var prefix: String = "";

            if (e.mode == InitAppEvent.SERVICE_USE_VLJ) {
                prefix = e.protocol + "://" + e.server + e.contextRoot + "/";
                model.rootURL = prefix;
                model.logoutURL = prefix + "logout.html?swfID=" + Application.application.parameters.swfID;
                model.helpContextRootURL = e.protocol + "://" + e.server + "/" + e.helpContextRoot + "/";
                if (e.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
                    if (!e.timeout) {
                        model.logoutURL = prefix + "reset.jsp";
                    }
                }
            }
            if (e.mode == InitAppEvent.SERVICE_USE_CSP) {
                prefix = e.protocol + "://" + e.server + "/";
                model.rootURL = prefix;
                model.logoutURL = prefix + "edp.logout.cls";
                model.helpContextRootURL = e.protocol + "://" + e.server + "/" + e.helpContextRoot + "/";
            }
            Services(ServiceLocator.getInstance()).callPrefix = prefix;
            Services(ServiceLocator.getInstance()).callMode = e.mode;
            model.appName = e.appName;
            model.contextRoot = e.contextRoot;

            if (e.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
                if (e.timeout) {
                    new InitUserDelegate(this).initUser(e.token);
                } else {
					initAnonymousUser(e.areaName,
						e.area, 
						e.siteId, 
						e.board,
						e.debug);						
				}
            } else {
                new InitUserDelegate(this).initUser(e.token);
            }
        }

        // don't call facility server for big board
        private function initAnonymousUser(areaName: String, area: int, sitecode:String, board:String, debug:String): void
        {
            model.session = new SessionVO();
            model.session.duz = "0";
            model.session.site = sitecode;
            model.session.siteName = "";
            model.session.area = area;
            model.session.areaName = areaName;
			model.session.board = board;
            model.session.baseTime = new Date();
            model.session.timeOut = 3600000;
            model.session.countDown = 0;
            model.session.canExport = false;
			model.session.showAdhocReport = false;
            model.session.showProviderReport = false;
            model.session.showPatientCrossReferenceReport = false;
			
			if(debug == "true") {
				model.session.debugEnabled = true; 
			} else {
				model.session.debugEnabled = false; 
			}
			
           
            
			//Alert.show("InitAppCommand session = " + model.session.toString());
			
	    // model.appViewList not used by big board (no menu on left side)
            //new TrackingEvent(TrackingEvent.EVENT_INIT_TRACKING).dispatch();

        }
		
		private function dropOut(event: CloseEvent):void {
//			model.logout();	
		}
		
		/**
		 * Handle the successful return of the service call.
		 * 
		 * @param data The payload from the service call.
		 */
        public override function result(data:Object):void
        {
            var xml:XML = ResultEvent(data).result as XML;

			//Alert.show("InitAppCommand -> result : " + xml);
			
            model.session = SessionFactory.buildSessionFromXML(xml);
//			if (model.session.roleID == "") {
//				Alert.show("You don't have a role assigned.  You will be allowed to log into EDIS, but please contact your VistA admin to assign you a role.", 
//					"No role",
//					Alert.OK, null,
//					dropOut, null, Alert.OK);
//			}
				
			
            model.appViewList = SessionFactory.buildAppViewListFromXML(xml.view);
			
			//model.workSheetList = SessionFactory.buildWorksheetListFromXML(xml.worksheets.role.worksheet);
			model.roles = new XMLList(xml.roles.children() as XMLList);
			
            // now that information has been obtained from the local facility
            // post this event to get the main server info and start the application
            new TrackingEvent(TrackingEvent.EVENT_INIT_TRACKING).dispatch();
			
			
			if(this.nextEvent != null) {
				(this.nextEvent as LoadWorkSheetEvent).role = model.session.roleID;
				executeNextCommand();
			}
						
        }

        protected override function getFaultMessage(fault:FaultEvent) : String {
            return "Unable to get user profile.";
        }

        protected override function createFaultDetail(fault:FaultEvent) : Object {
            var detail:Object = super.createFaultDetail(fault);
            detail.callPrefix = ﻿Services(ServiceLocator.getInstance()).callPrefix;
            detail.callMode = ﻿Services(ServiceLocator.getInstance()).callMode;
            return detail;
        }
	
    }
}
